*******************************************************************************
*                         680xx Grundprogramm einzel                          *
*                         (C) 1990 Ralph Dombrowski                           *
*                             2008 Jens Mewes                                 *
*                                 Rev 7.10                                    *
*                                01.01.2008                                   *
*                         Menpunkt Einzelschritt                             *
*******************************************************************************


einzel:                         * Einzelschrittverarbeitung mit DIS-Assembler
 btst.b #4,tracflag(a5)         * Trace nicht im Trace aufrufen
 bne carset
 lea tractxt0(pc),a0            * berschrift ausgeben
 bsr headaclr
 lea tractxt1(pc),a0            * Befehlsbersicht
 moveq #$32,d0
 move #160,d2
 bsr centertxt                  * berschrift
 lea tractxt2(pc),a0
 moveq #$21,d0
 moveq #5,d1
 move #140,d2
 bsr textprint                  * Befehle auflisten
 bsr getadr                     * Adresse Beginn holen
 bcs carset                     * Bei Fehler Abbruch
 move.l a7,stackmerk(a5)        * Stack merken, daher TRACE auch als Unterprogr
 or.b #%00010000,tracflag(a5)   * Trace ist jetzt an
 move.b #1,first(a5)            * Turtle erster Aufruf
 move.b #1,turdo(a5)            * Turtle down
 pea tracende(pc)               * Rcksprungadresse
*clr -(a7)                      * Bei 68010 mu der Befehl eingefgt werden !!!
 move.l d0,-(a7)                * Adresse RTE
 move sr,-(a7)                  * Statusregister merken
 bsr clrall                     * Bildschirm lschen
 clr.b tracausw(a5)             * Kein Extramodus
 clr.b trac1aus(a5)             * Kein Merker
 movem.l d0-d7/a0-a7,regsave(a5)* Alle Register merken
bra traceb

tracein:                        * Einsprung Ausnahme-Bedingung durch TRACE-BIT
 move.l a5,-(a7)                * (a7) -> SR     2(a7) -> PC
 lea basis(pc),a5
 adda.l ramstart(pc),a5         * a5 in Ordnung bringen
 movem.l d0-d7/a0-a6,regsave(a5)* Register bergeben
 move.l (a7)+,regsave+4*13(a5)  * a5 jetzt auch ablegen
 move.l a7,regsave+4*15(a5)     * Jetzt erst a7 retten
 lea tracende(pc),a0            * Ist Ende des Programms erreicht ?
 cmpa.l 2(a7),a0
 beq tracende                   * Ja, also Ende TRACE
 tst.b tracausw(a5)             * Spezialmodus angeschaltet ?
 beq.s traceb                   * Nein, dann weiter
 cmp.b #1,tracausw(a5)          * n-Befehle ausfhren
 bne.s tracea
 subq.l #1,tracmerk(a5)         * Tracmerk um Eins verringern
 bne traceok1                   * Wenn Null, dann Ende
bra.s tracea3                   * Normal weiter
tracea:
 cmp.b #2,tracausw(a5)          * Bis Adresse ausfhren
 bne.s tracea1
 move.l tracmerk(a5),d0         * Vergleich, ob
 sub.l 2(a7),d0                 * Bereich
 bpl.s tracea0
 neg.l d0                       * Nur positiver Bereich
tracea0:
 moveq #0,d1
 move tracmerk+4(a5),d1         * Bereich
 cmp.l d1,d0
 bhi traceok1                   * Bereich nicht erreicht
bra.s tracea3                   * Normal weiter
tracea1:
 cmp.b #3,tracausw(a5)          * Ausfhren bis ADRESSE & MASKE WERT annimmt
 bne.s tracea2
 movea.l tracmerk(a5),a0        * Adresse
 move.b (a0),d0                 * Maske
 and.b tracmerk+4(a5),d0
 cmp.b tracmerk+5(a5),d0        * Vergleich
 bne traceok1                   * Nein, Adresse hat nicht gewnschten Wert
bra.s tracea3                   * Normal weiter
tracea2:
 cmp.b #4,tracausw(a5)          * Bis ENDE Unterprogramm
 bne.s traceb
 movea.l 2(a7),a0
 move (a0),d0
 cmp #$4e75,d0                  * RTS
 beq.s tracea3
 cmp #$4e73,d0                  * RTE
 beq.s tracea3
 cmp #$4e77,d0                  * RTR
 bne traceok1                   * Durchstarten, da nicht gefunden

tracea3:
 clr.b tracausw(a5)             * Spezialmodus aus, normal weiter

traceb:
 move (a7),srsave(a5)           * SR jetzt merken
 move.l 2(a7),pcsave(a5)        * PC jetzt merken
 move.l usp,a0                  * USP auch ablegen
 move.l a0,uspsave(a5)
 move.l a7,sspsave(a5)          * SSP ist a7
 lea gdp+1*cpu.w,a0             * GDP-Register retten, da zerstrt
 lea gdpsave(a5),a1             * Register Null nicht retten
 bsr wait                       * Warten bis GDP fertig ist
 moveq #15-4-1,d1
tracec:
 move.b (a0),(a1)+              * Werte bertragen
 addq.l #cpu,a0
dbra d1,tracec
                                * OK, Register gerettet
traced:                         * Status-Zeilen ausgeben
 bsr trdump                     * Alle Register / DEBUG oder DIS-ASsembler
 bcs.s tracee
 btst.b #1,tracflag(a5)         * Protokol auf Drucker ?
 beq.s tracee                   * Nein
 clr.b (a1)                     * Keine Leerzeichen mehr am Ende
 lea einbuf(a5),a0              * Ja, dann DEBUG oder DIS-Assembler ausgeben
 move.l pcsave(a5),d0           * Adresse Befehl
 bsr print8x                    * Hexadezimal ausgeben
 move #'  ',(a0)+               * Dann Leerzeichen
 clr.b (a0)                     * und Endekennung
 lea einbuf(a5),a0
 bsr prtlo                      * Auf Drucker ausgeben
 lea ausbuf(a5),a0
 bsr prtlo                      * Und Befehl auch auf Drucker ausgeben
 bsr locrlf                     * Dann Linefeed

tracee:                         * Befehlsabfrage
 bsr ki                         * Zeichen von Tastatur holen
 cmp.b #$d,d0                   * Return fhrt nchsten Befehl aus
 beq traceok

traceeb:                        * Bis ADRESSE + Bereich ausfhren
 cmp.b #'B',d0
 bne.s traceec
 bsr wrtupd0                    * Eingabe
 movea.l a0,a4                  * Adresse merken
traceeb0:                       * Suchen bis ','
 tst.b (a4)
 beq.s traceeb1                 * Ende bei Null
 cmp.b #',',(a4)+
 bne.s traceeb0
 clr.b -1(a4)                   * Ende fr ersten Wert
traceeb1:
 bsr wertmfeh                   * Ersten Wert holen
 bcs tracee                     * Ende bei Fehler
 move.l d0,tracmerk(a5)         * Adresse merken
 move.l d0,trac1mer(a5)         * Auch fr WIEDERHOLEN
 clr tracmerk+4(a5)             * Bereich ist Null
 movea.l a4,a0                  * Adresse fr eventuellen zweiten Wert
 bsr igbn
 tst.b (a0)
 beq.s traceeb2                 * Kein Bereich
 clr.b trac1ausw(a5)            * Kein Wiederholen mehr mglich
 bsr wertmfeh                   * Bereich holen
 bcs tracee                     * Fehler
 move d0,tracmerk+4(a5)         * Bereich merken
traceeb2:
 move.b #2,tracausw(a5)         * Flag
 move.b #2,trac1aus(a5)         * Auch merken
bra traceok                     * Durchstarten

traceec:                        * Screen lschen
 cmp.b #'C',d0
 bne.s traceed
 bsr clrall                     * Bildschirm lschen alle Seiten
 bsr trdump                     * Regdump neu ausgeben
bra tracee

traceed:                        * TRAP/JSR direkt ausfhren oder nicht
 cmp.b #'D',d0
 bne.s traceee
 bchg.b #2,tracflag(a5)         * Flag umschalten
 bsr trdump                     * Regdump neu
bra tracee

traceee:
 cmp.b #'E',d0                  * Bis RTS/RTE/RTR
 bne.s traceef
 move.b #4,tracausw(a5)         * Code fr Befehl
 move.b #4,trac1aus(a5)         * Fr Wiederholen
bra traceok

traceef:                        * Flags laden
 cmp.b #'F',d0
 bne.s traceeg
 bsr wrtupdate                  * Wert holen
 bcs tracee                     * Fehler ist Abbruch
 cmp #31,d0                     * Wert nicht neagtiv
 bhi tracee                     * und nicht grer als 31, da Flags nur 5 Bit
 move.b d0,srsave+1(a5)         * Flags abspeichern
 move.b d0,1(a7)                * Auch in Stack, damit bei RTE geladen wird
 bsr trdump                     * Regdump neu
bra tracee

traceeg:                        * Grundprogrammroutinen aufrufen
 cmp.b #'G',d0
 bne.s traceei
 bsr wrtupdate                  * Wert holen
 bcs tracee                     * Bei Fehler Abbruch
 move d0,d1                     * Wert merken
 bpl.s traceeg1                 * Wenn Wert positiv, dann OK
 neg d1                         * Sonst positiv machen
 cmp #maxgrund,d1               * Und mit maximaler Anzahl vergleichen
 bhi tracee                     * Zu hoch, Abbruch
 cmp #21,d1                     * Trace kann nicht Trace aufrufen
 beq tracee
traceeg1:
 move.b menflag(a5),-(a7)       * Menauswahl merken
 bsr grund                      * Aufrufen
 move.b (a7)+,menflag(a5)       * Auch wieder zurck
 bsr clrall                     * Danach wieder Bildschirm lschen
 bsr trdump                     * Regdump neu
bra tracee

traceei:                        * Info an/aus
 cmp.b #'I',d0
 bne.s traceel
 bchg.b #0,tracflag(a5)         * Flag ndern
 bne.s *+10                     * Wenn jetzt auf Eins, dann nur ausgeben
 bsr trdump                     * Regdump neu
bra tracee
 bsr.s traceei0                 * Sonst unten lschen
 bsr.s traceei0                 * Lschen
 bsr setpen                     * Wieder auf Schreiben
bra tracee                      * Nchsten Befehl holen

traceei0:                       * Unten 6 Zeilen lschen
 bsr erapen                     * Auf Lschen schalten
 move.b #5,gdp.w                * X und Y auf Null
 move.b #$16,gdp+3*cpu.w        * Gre einstellen
 moveq #%1010,d0                * Kasten
 moveq #85-1,d3
traceei1:
 bsr cmd                        * Lschzeichen ausgeben
dbra d3,traceei1
 eori.b #1,wrtpage(a5)          * Danach andere Seite
bra aktpage                     * Da, zweimal aufgerufen, spter wieder OK

traceel:                        * Extrafunktionen wiederholen
 cmp.b #'L',d0
 bne.s traceem
 move.b trac1aus(a5),tracausw(a5)       * Flag holen
 beq tracee                     * Kein Wiederholen mglich
 move.l trac1mer(a5),tracmerk(a5)       * Und Wert neu laden
bra traceok                     * Durchstarten

traceem:                        * Tracende
 cmp.b #$1b,d0                  * <ESC> = Abbruch
 beq tracende
 cmp.b #'M',d0
 beq tracende                   * Abbruch

traceen:                        * n Befehle ausfhren
 cmp.b #'N',d0
 bne.s traceep
 bsr wrtupdate                  * Anzahl holen
 bcs tracee                     * Abbruch bei Fehler
 tst.l d0                       * Wenn Null oder
 beq tracee                     * Negativ
 bmi tracee                     * dann Abbruch
 move.l d0,tracmerk(a5)         * Anzahl abspeichern
 move.l d0,trac1mer(a5)
 move.b #1,tracausw(a5)         * Flag fr Befehl
 move.b #1,trac1aus(a5)
bra traceok                     * Durchstarten

traceep:                        * PC neu laden (Achtung eventuell Stackchaos)
 cmp.b #'P',d0
 bne.s traceer
 bsr wrtupdate                  * Wert holen
 bcs tracee                     * Abbruch
 cmp.l #grenze,d0               * Maximale Speicherausbaumglichkeit darf nicht
 bhi tracee                     * berschritten werden
 and.b #$fe,d0                  * Auf gerade Adresse bringen
 move.l d0,2(a7)                * Abspeichern fr RTE
 move.l d0,pcsave(a5)           * Auch fr Regdump
bra traced                      * Regdump mit neuer Adresse

traceer:                        * Register einzeln laden
 cmp.b #'R',d0                  * Register + Nummer d0-d7/8 a0-a7
 bne tracees                    * Bei Eingabe einer 8 werden alle Register
 bsr wrtupd0                    * angezeigt
 bsr igbn
 move.b (a0)+,d0
 bsr bucheck
 move.b d0,d4                   * d4 ist Buchstabe fr Register
 lea regsave(a5),a4             * Adresse in REGSAVE fr Datenregister
 cmp.b #'D',d0                  * 'D' ?
 beq.s traceer0                 * Dann Datenregister ndern
 lea regsave+4*8(a5),a4         * Adresse fr Adressregister
 cmp.b #'A',d0                  * 'A' ?
 bne tracee                     * Dann Adressregister ndern
traceer0:                       * d5 Tabellen-Offset
 bsr wertmfeh                   * d4 Buchstabe des Registers
 bcs tracee
 move d0,d6                     * d6 Nummer des Registers
 cmp #8,d0
 bhi tracee                     * Zu gro !
 beq.s traceer1
 bsr.s traceer3                 * Nur ein Register ndern
bra tracee
traceer1:
 clr    d6                      * 7 Register ndern
traceer2:
 move   d6,-(a7)
 bsr.s  traceer3                * Register ndern
 move   (a7)+,d6
 addq   #1,d6
 cmp    #8,d6
bne.s traceer2
bra tracee                      * Ende

traceer3:
 move d6,d5
 add d5,d5
 add d5,d5                      * Nummer des Registers mal 4
 lea 0(a4,d5.w),a3              * Adresse des Registers in REGSAVE
traceer4:
 lea einbuf(a5),a0
 move.b d4,(a0)+
 move.b d6,(a0)
 add.b #'0',(a0)+
 move.w #':'*256,(a0)
 lea einbuf(a5),a0
 moveq #$11,d0
 moveq #2,d1
 move #245,d2
 bsr textaus                    * Ausgabe Registernummer mit Doppelpunkt
 move.l (a3),d0
 bsr put8x                      * Wert in Hexadezimal
 lea einbuf(a5),a0
 moveq #$11,d0
 moveq #20,d1
 moveq #12,d3
 move d4,-(a7)                  * d4 merken
 bsr readaus                    * Neuen Wert holen
 movem (a7)+,d4                 * d4 zurck
 bcs carres                     * Abbruch
 lea einbuf(a5),a0
 bsr igbn
 tst.b (a0)
 beq carres                     * Wenn nichts eingegeben wurde, dann Ende
 bsr wertmfeh                   * Wert ermitteln
 bcs.s traceer4                 * Fehler
 move.l d0,(a3)                 * Register abspeichern
bra trdump

tracees:                        * Leseseite neu whlen
 cmp.b #'S',d0
 bne.s traceet
 bsr wrtupdate                  * Seite holen
 bcs tracee
 cmp.b #3,d0                    * Mu zwischen 0 und drei liegen
 bhi tracee
 clr.b flip(a5)                 * Keine Seitenumschaltung mehr
 clr.b flip1(a5)
 move.b d0,viewpage(a5)         * Und einstellen
 bsr aktpage
 bsr trdump                     * Regdump neu
bra tracee

traceet:                        * Tabellieren auf Drucker (an/aus)
 cmp.b #'T',d0
 bne.s traceew
 bchg.b #1,tracflag(a5)         * Umschalten
 bsr trdump                     * Regdump neu
bra tracee

traceew:                        * Weiter bis ADRESSE & MASKE WERT enthlt
 cmp.b #'W',d0
 bne tracee
 bsr wrtupdate                  * Adresse holen
 bcs tracee                     * Bei Fehler Abbruch
 clr.b trac1aus(a5)             * Kein Wiederholen mehr mglich
 move.l d0,tracmerk(a5)         * Merken
 move.l d0,trac1mer(a5)
 bsr wrtupdate                  * Maske holen
 bcs tracee
 move.b d0,tracmerk+4(a5)       * Auch merken
 bsr wrtupdate                  * Wert holen
 bcs tracee
 move.b d0,tracmerk+5(a5)       * Auch merken
 move.b #3,tracausw(a5)         * Nummer des Befehls
 move.b #3,trac1aus(a5)

traceok:                        * Befehl ausfhren
 lea gdp+1*cpu.w,a0             * GDP-Register zurck
 lea gdpsave(a5),a1
 bsr wait                       * Warten bis GDP fertig ist
 moveq #15-4-1,d1
traceok0:
 move.b (a1)+,(a0)              * Werte bertragen
 addq.l #cpu,a0
dbra d1,traceok0
traceok1:
 btst.b #2,tracflag(a5)
 beq.s traceok2                 * TRAP/JSR geschlossen ausfhren ?
 movea.l 2(a7),a0               * Ja, geschlossen ausfhren
 move (a0),d0
 cmp #$4eb8,d0
 beq.s jsrkex                   * JSR.w Befehl
 cmp #$4eb9,d0
 beq.s jsrlex                   * JSR.l Befehl
 and #$fff0,d0
 cmp #$4e40,d0
 beq.s trapex                   * Trap
traceok2:
 or #$8000,(a7)                 * Tracflag neu setzen
 movem.l regsave(a5),d0-d7/a0-a6* Register zurck
rte                             * Zurck und nchsten Befehl ausfhren

jsrkex:                         * JSR.w als Ganzes ausfhren
 move.l (a0),modber(a5)
 move #$4e75,modber+4(a5)
 addq.l #4,2(a7)                * Befehl + RTS abgespeichert PC erhht
bra.s trapex1

jsrlex:                         * JSR.l als Ganzes ausfhren
 move (a0),modber(a5)
 move.l 2(a0),modber+2(a5)
 move #$4e75,modber+6(a5)       * Befehl + RTS abgespeichert
 addq.l #6,2(a7)                * PC erhht
bra.s trapex1

trapex:                         * Trap als Ganzes ausfhren
 move (a0),modber(a5)
 move #$4e75,modber+2(a5)
 addq.l #2,2(a7)                * Befehl + RTS abgespeichert PC erhht
trapex1:
 move (a7),d0
 and #$3fff,d0
 move d0,sr                     * Altes Statusregister ohne TRACE
 pea jsrtrapex(pc)
 pea modber(a5)                 * Adresse der Befehlsausfhrung
 movem.l regsave(a5),d0-d7/a0-a6* Register zurck
rts

jsrtrapex:
 movem.w d0,-(a7)
 move sr,d0
 move.b d0,3(a7)                * Flags wie am Ende des Unterprogramms
 move.w (a7)+,d0
bra tracein                     * Einsprung wie bei Exception

tracende:                       * Ende TRACE
 bclr.b #4,tracflag(a5)         * Trace aus
 movea.l stackmerk(a5),a7       * Stack zurck, falls mittendrin abgebrochen
 move.b #1,first(a5)            * Turtle auf first
 move.b #1,turdo(a5)            * Und down
 clr.b flip(a5)                 * Keine Seitenumschaltung
 clr.b flip1(a5)
 clr oldsize(a5)                * Keine alte Figur
 clr.b xormode(a5)              * XORMODE mu aus
 clr.b gdpscroll(a5)            * Merken
 btst.b #0,ioflag(a5)
 beq erakreuz
 clr.b page1.w                  * Bei neuer GDP Scroll ausschalten
bra erakreuz                    * Kreuz sicherheitshalber aus

wrtupdate:                      * Wert nach d0 holen fr Trace
 bsr.s wrtupd0
bra wertmfeh                    * Wert berechnen mit Fehlerbehandlung

wrtupd0:
 move.b viewpage(a5),d0
 lsl.b #2,d0
 or.b viewpage(a5),d0
 lsl.b #4,d0
 bsr setpage                    * Leseseite = Schreibseite setzen
 lea einbuf(a5),a0
 moveq #$11,d0
 moveq #2,d1
 move #255-10,d2
 moveq #20,d3
 bsr textein                    * Text von der Tastatur holen
 bsr aktpage                    * Alte Seite einstellen
 lea einbuf(a5),a0
rts

trdump:
 btst.b #0,tracflag(a5)
 beq carset                     * Kein Regdump
regdump:                        * Ausgabe aller Register und DEBUG
 lea ausbuf(a5),a0
 move.l #'Reg:',(a0)+           * Erste Zeile herstellen
 moveq #'0',d0
 moveq #8-1,d1
regdump0:
 move #'  ',(a0)+
 move.b d0,(a0)+                * Nummer des Registers 0-7
 addq.b #1,d0
 move.b #' ',(a0)+
 move #'  ',(a0)+
 move.l #'    ',(a0)+
dbra d1,regdump0
 clr.b (a0)                     * Endekennung
 btst.b #4,tracflag(a5)
 beq.s regdump2                 * Kein Trace, dann weiter
 btst.b #2,tracflag(a5)         * TRAP/JSR direkt ausfhren ?
 bne.s regdump1                 * Nein, dann weiter
 move.b #'D',-1(a0)             * Kennung, da direkt ausgefhrt wird
regdump1:
 btst.b #1,tracflag(a5)         * Protokol auf Drucker an ?
 beq.s regdump2                 * Nein, dann weiter
 move.l #'List',-6(a0)          * Kennung, da Protokol an ist
regdump2:
 lea ausbuf(a5),a0
 moveq #$11,d0
 moveq #0,d1
 moveq #40,d2
 bsr textaus                    * Oberste Zeile ausgeben
 eori.b #1,wrtpage(a5)
 bsr aktpage                    * Andere Seite
 moveq #$11,d0
 bsr textaus                    * Auch dort
 lea ausbuf(a5),a0
 move.l #'Dn :',(a0)+           * Alle Datenregister
 lea regsave(a5),a1             * Dort liegen sie
 moveq #8-1,d1                  * 8 gibt es
regdump3:
 move #'  ',(a0)+               * Dazwischen Leerraum
 move.l (a1)+,d0                * Wert holen / liegt in regsave
 bsr print8x                    * Hexadezimal ausgeben
dbra d1,regdump3
 addq.l #2,a0
 move.l #'An :',(a0)+           * Jetzt Adressregister
 moveq #8-1,d1                  * Auch 8
regdump4:
 move #'  ',(a0)+
 move.l (a1)+,d0
 bsr print8x
dbra d1,regdump4
 addq.l #2,a0
 move.l #'SR :',(a0)+           * Statusregister
 move.w #'  ',(a0)+
 move srsave(a5),d0
 move d0,d1
 bsr print16b                   * 16 Stellen binr ausgeben
 move.b #'-',-15(a0)            * Unbenutzte Bits streichen
 move.b #'-',-13(a0)            * ist bersichtlicher
 move.b #'-',-12(a0)
 move #'--',-8(a0)
 move.b #'-',-6(a0)
 lea flags(pc),a2               * Gesetzte Flags als Buchstaben ausgeben
 lea 1(a0),a1                   * Zieladresse
 move.l #'    ',(a0)+
 move.l #'   U',(a0)+
 moveq #5-1,d0                  * 5 Flags gibt es
regdump5:
 btst d0,d1                     * Flag prfen, ob gesetzt
 beq.s regd5a
 move.b (a2),(a1)+              * Gesetzt, also ausgeben
regd5a:
 addq.l #1,a2                   * Nchster Buchstabe
dbra d0,regdump5                * Nchstes Bit
 move.l #'SP :',(a0)+           * Jetzt USP
 move.w #'  ',(a0)+
 move.l uspsave(a5),d0
 bsr print8x                    * Hexadezimal 8 Stellen
 move.l #'    ',(a0)+           * Leerraum
 move.l #' SSP',(a0)+
 move.l #' :  ',(a0)+
 move.l Sspsave(a5),d0          * Jetzt SSP
 bsr print8x                    * Auch 8 Stellen hexadezimal
 move.l #'    ',(a0)+           * Leerraum
 move.l #'  PC',(a0)+
 move.l #' :  ',(a0)+           * Jetzt PC
 move.l pcsave(a5),d0
 bsr print8x                    * 8 Stellen hexadezimal
 moveq #2-1,d3                  * Alles auf zwei Seiten ausgeben
regdump6:
 lea ausbuf(a5),a0              * Zweite Zeile
 moveq #$11,d0
 moveq #0,d1
 moveq #30,d2
 bsr textaus
 lea ausbuf+86(a5),a0           * Dritte Zeile
 moveq #20,d2
 bsr textaus
 lea ausbuf+172(a5),a0          * Vierte Zeile
 moveq #10,d2
 bsr textaus
 eori.b #1,wrtpage(a5)          * Andere Seite
 bsr aktpage
dbra d3,regdump6
regdin:                         * Einsprung
 tst.b debug(a5)                * Debug an ?
 beq.s nodebugi                 * Nein, dann DIS-Assembler
 movea.l debugst(a5),a0         * Anfangsadresse
 movea.l pcsave(a5),a1          * Befehlsadresse
regdump7:
 move.l (a0),d0
 beq.s nodebugi                 * Ende der Debugtabelle erreicht
 cmp.l a1,d0                    * Stimmt Adresse
 beq.s regdump8                 * Ja, stimmt
 addq.l #8,a0                   * Nein, Tabellenpointer erhhen
bra.s regdump7                  * Weitersuchen

flags:
 dc.b 'XNZVC',0                 * Flags des Statusregister

regdump8:                       * Befehl in der Tabelle gefunden
 movea.l 4(a0),a1               * Adresse Text holen
 lea ausbuf(a5),a0              * In ausbuf ablegen
 moveq #85-1,d1                 * Maximal 85 Zeichen
regdump9:
 move.b (a1)+,d0
 beq.s nodebug2                 * Null ist Ende
 cmp.b #$d,d0
 beq.s nodebug2                 * $d auch
 cmp.b #$a,d0
 beq.s regdump9                 * $a ignorieren
 move.b d0,(a0)+                * Buchstaben ablegen
dbra d1,regdump9                * Nchsten holen
 movea.l a0,a1                  * Merken fr Druckerausgabe
bra.s nodebugfi                 * Befehlstext ausgeben

nodebugi:                       * Wenn kein Debug, dann Disassembler
 movea.l pcsave(a5),a3          * Adresse des Befehls
 bsr disass                     * Dis-Assemblieren
nodebug0:
 lea einbuf(a5),a1              * In einbuf steht Dis-Assemblierter Befehl
 lea ausbuf(a5),a0              * Dort mu er hin
 moveq #85-1,d1
nodebug1:
 move.b (a1)+,(a0)+             * bertragen bis Null erreicht
dbeq d1,nodebug1
 subq.l #1,a0
nodebug2:
 movea.l a0,a1                  * Adresse merken fr Druckerausgabe
 tst d1
 bmi.s nodebugfi                * Ende, wenn Zeile voll
nodebug3:
 move.b #' ',(a0)+              * Rest mit Leerzeichen auffllen
dbra d1,nodebug3
nodebugfi:                      * Dis-Assembler oder DEBUG ausgeben
 clr.b (a0)                     * Endekennung
 lea ausbuf(a5),a0              * Dort steht Text
 moveq #$11,d0
 moveq #0,d1
 moveq #0,d2
 bsr textaus                    * Ausgeben
 eori.b #1,wrtpage(a5)
 bsr aktpage                    * Andere Seite
 moveq #$11,d0
 bsr textaus                    * Auch dort ausgeben
 btst.b #4,tracflag(a5)
 beq carres                     * Kein Trace, dann Ende
 btst.b #1,tracflag(a5)         * Protokol auf Drucker ?
 beq carres                     * Nein
 clr.b (a1)                     * Keine Leerzeichen mehr am Ende
 lea einbuf(a5),a0              * Ja, dann DEBUG oder DIS-Assembler ausgeben
 move.l pcsave(a5),d0           * Adresse Befehl
 bsr print8x                    * Hexadezimal ausgeben
 move #'  ',(a0)+               * Dann Leerzeichen
 clr.b (a0)                     * und Endekennung
 lea einbuf(a5),a0
 bsr prtlo                      * Auf Drucker ausgeben
 lea ausbuf(a5),a0
 bsr prtlo                      * Und Befehl auch auf Drucker ausgeben
 bsr locrlf                     * Dann Linefeed
bra carres                      * Ausgabe erfolgte
                                                                                                                                                                                                                                                                           
 add d0,d2                      * Zeichenzahl addieren
 addq #1,d1                     * Nchste Zeile
bra.s editadr1                  * Schleife
editadr2:
 bsr calccur                    * Cursorposition holen
 cmp.b #$7f,(a0)
 beq.s editadr3                 * Bei Leerzeile weiter
 move.b d1,d0
 bsr getzlen                    * Wirkliche Zeilenlnge holen
 subq #2,d0                     * CR LF weg
 move.b curx(a5),d1
 add d1,d2
 cmp.b d0,d1                    * Cursor hinter Zeilenende ?
 bm